/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   分页器
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.8.19
 *      内容 : 所有代码
 *************************************************************************************************/
/* exported mc_tpl_param */
/* exported mc_tpl_box_template_save */

/* global  mc_sdk_get_box_tplparam_list */
/* global  mc_sdk_param */
/* global  mc_sdk_set_box_tplparam */
function mc_tpl_param(str_box_name, ary_box_data, ary_mod_data) {
    /* *************************** 声明 ********************************************* */
    // 模板参数列表
    var m_ary_tpl_list = [];
    // 当前箱体参数(用以对比匹配度)
    var m_obj_box_param = {};

    /* *************************** API ********************************************* */
    // 箱体名称(必须:如果获取异常报错)***
    this.box_name = str_box_name ? str_box_name : "";
    // 箱体数据(必须:如果获取异常报错)***
    this.box_data = ary_box_data ? ary_box_data : [];
    // 模组数据(必须:如果获取异常报错)***
    this.mod_data = ary_mod_data ? ary_mod_data : [];

    /**
     * 初始化模板参数列表内容
     * @param {Promise<Function>} fn_callback
     */
    this.int_box_msg = function (fn_callback) {
        // 获取箱体指定参数
        var ui_box_idx = mc_tpl_get_idx_by_name(this.box_data, this.box_name);
        // 当前箱体
        var obj_box_data = this.box_data[ui_box_idx];

        // 箱体下第一个模组
        var str_first_mod_name = obj_box_data.data.mc_util_get_box_first_mod_name();
        var ui_mod_idx = mc_tpl_get_idx_by_name(this.mod_data, str_first_mod_name);
        var obj_mod_data = this.mod_data[ui_mod_idx].data;

        // 匹配参数
        var obj_box_tpl_cig = {
            str_disp_name: obj_mod_data.mc_util_mod_get_disp_chip(),
            str_ctrl_name: obj_box_data.data.mc_util_get_ui_box_msg().ctrlchip_name,
            str_scan_name: obj_mod_data.mc_util_mod_get_scan_chip(),
            str_str_cnt: obj_mod_data.mc_util_mod_get_str_cnt() + "",
            str_sclk_cnt: obj_mod_data.mc_util_mod_get_sclk_pin_cnt() + "",
            str_scan_cnt: obj_mod_data.mc_util_mod_get_max_scan_cnt() + "",
            str_scan_len: obj_mod_data.mc_util_mod_get_max_scan_len() + ""
        };

        m_obj_box_param = obj_box_tpl_cig;

        // 获取匹配列表
        mc_sdk_get_box_tplparam_list(m_obj_box_param, function (str_res_json) {
            var obj_sdk_param = new mc_sdk_param();

            if (!obj_sdk_param.set_json(str_res_json)) {
                fn_callback();
            }
            var ary_tpl_list = [];
            var ui_param_cnt = obj_sdk_param.get_param_cnt();

            for (var idx_param = 0; idx_param < ui_param_cnt; idx_param++) {
                var str_disp_name = obj_sdk_param.get_param_name(idx_param);
                var ui_attr_cnt = obj_sdk_param.get_attr_cnt(str_disp_name);

                if ("ERROR_CODE" === str_disp_name) {
                    continue;
                }
                for (var idx_attr = 0; idx_attr < ui_attr_cnt; idx_attr++) {
                    var str_feaure_key = obj_sdk_param.get_attr_name(str_disp_name, idx_attr);
                    var str_feaure_json = obj_sdk_param.get_attr_val(str_disp_name, str_feaure_key);
                    var obj_feaure_param = new mc_sdk_param();

                    if (!obj_feaure_param.set_json(str_feaure_json)) {
                        continue;
                    }
                    var ary_param_name = [
                        "CTRLCHIP",
                        "DISPCHIP",
                        "SCANCHIP",
                        "SCANCNT",
                        "SCANLEN",
                        "SCLKCNT",
                        "STRCNT"
                    ];
                    var ary_obj_name = [
                        "str_ctrl_name",
                        "str_disp_name",
                        "str_scan_name",
                        "str_scan_cnt",
                        "str_scan_len",
                        "str_sclk_cnt",
                        "str_str_cnt"
                    ];
                    var ui_count_idx = 0;
                    var ui_match_num = 0;
                    var ary_match_list = [[0], [0], [0], [0], [0], [0], [0]];

                    while (7 !== ui_count_idx) {
                        var str_feaure_param_val = obj_feaure_param.get_param_value(ary_param_name[ui_count_idx]);
                        var str_count_param_val = obj_box_tpl_cig[ary_obj_name[ui_count_idx]];

                        if (str_feaure_param_val === str_count_param_val) {
                            ui_match_num++;
                            ary_match_list[ui_count_idx][0] = 1;
                        }
                        ary_match_list[ui_count_idx][1] = str_feaure_param_val;
                        ui_count_idx++;
                    }
                    var str_crt_time = obj_feaure_param.get_param_value("EDITTIME");
                    var str_tpl_descript = obj_feaure_param.get_param_value("DESCRIPT");
                    var str_tpl_name = obj_feaure_param.get_param_value("NAME");

                    if (0 === ary_tpl_list.length) {
                        ary_tpl_list[0] = {
                            feaure_key: str_feaure_key,
                            feaure_json: str_feaure_json,
                            match_num: ui_match_num,
                            match_list: ary_match_list,
                            crt_time: str_crt_time,
                            descrit: str_tpl_descript,
                            tpl_name: str_tpl_name
                        };
                        continue;
                    }
                    var idx_list = 0;

                    for (idx_list = 0; idx_list < ary_tpl_list.length; idx_list++) {
                        var ui_match_num_list = ary_tpl_list[idx_list].match_num;

                        if (ui_match_num_list < ui_match_num) {
                            break;
                        }
                    }
                    ary_tpl_list.splice(idx_list, 0, {
                        feaure_key: str_feaure_key,
                        feaure_json: str_feaure_json,
                        match_num: ui_match_num,
                        match_list: ary_match_list,
                        crt_time: str_crt_time,
                        descrit: str_tpl_descript,
                        tpl_name: str_tpl_name
                    });
                }
            }

            m_ary_tpl_list = ary_tpl_list;
            fn_callback();
        });
    };

    /**
     * 获取模板参数列表
     * @returns {Promise<Array>} 模板参数列表
     */
    this.get_tpl_param_list = function () {
        return m_ary_tpl_list;
    };

    /**
     * 根据下标获取指定模板参数内容
     * @param {Promise<Number>} ui_param_idx 指定下标
     * @returns {Promise<Object>} 模板参数
     */
    this.get_tpl_param_by_idx = function (ui_param_idx) {
        return m_ary_tpl_list[ui_param_idx];
    };

    /**
     * 根据下标获取指定模板参数内容
     * @param {Promise<Number>} ui_param_idx 指定下标
     * @returns {Promise<String>} 当前选中模板参数识别符
     */
    this.get_tpl_param_key_by_idx = function (ui_param_idx) {
        var str_feature_key = m_ary_tpl_list[ui_param_idx].feaure_key;

        return str_feature_key;
    };

    this.get_box_cfg = function () {
        return m_obj_box_param;
    };
    /* *************************** 事件 ********************************************* */
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    保存模板
 * 参数:
 *    @param {Promise<String>} str_box_name 箱体名称
 *    @param {Promise<Array>} ary_box_data 箱体数据
 *    @param {Promise<String>} str_tpl_title 模板标题
 *    @param {Promise<String>} str_tpl_descrit 模板描述
 *    @param {Promise<Function>} fn_callback 回调函数
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.11.12
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_tpl_box_template_save(str_box_name, ary_box_data, str_tpl_title, str_tpl_descrit, fn_callback) {
    var ui_box_idx = mc_tpl_get_idx_by_name(ary_box_data, str_box_name);
    var obj_box_data = ary_box_data[ui_box_idx];

    mc_sdk_set_box_tplparam(obj_box_data, str_tpl_title, str_tpl_descrit, function (str_sdk_res) {
        var obj_sdk_param = new mc_sdk_param();

        if (!obj_sdk_param.set_json(str_sdk_res)) {
            fn_callback("MC_LANG_GET_PARAM_ERROR_1");
            return;
        }
        var str_error_code = obj_sdk_param.get_param_value("ERROR_CODE");

        if ("0x00000000" !== str_error_code && str_error_code) {
            fn_callback(str_error_code);
            return;
        }


        fn_callback("0");
    });
}

/************************************************************************************************
* 类型:
*    函数
* 功能:
*    根据name属性值获取列表中匹配下表
* 参数:
*    @param {Promise<Array>} ary_list 查询列表
*    @param {Promise<String>} str_name_val name属性值
* 返回：
*    @returns {Promise<Number|Boolean>} 获取结果
* 备注:
*    NA
* 修改:
*   1. 类型 : 创建
*      作者 : 徐烁超
*      时间 : 2020.12.4
*      内容 : 所有代码
************************************************************************************************/
function mc_tpl_get_idx_by_name(ary_list, str_name_val) {
    for (var idx_list = 0; idx_list < ary_list.length; idx_list++) {
        if (str_name_val === ary_list[idx_list].name) {
            return idx_list;
        }
    }
    return false;
}
